// Bomb Jack versión para MSX-1
// 
// Proyecto-aprendizaje del TFG
// EUI UPV 2020
//
// Frederic Garcia Nieto (2020)
//
// Libreria con los tipos de datos y algunas definiciones


//------ Paleta de colores ------
#define negro			0x01
#define verde 			0x02
#define verde_oscuro	0x0C
#define verde_claro 	0x03
#define azul_celeste 	0x07
#define azul_oscuro		0x04
#define azul_claro 		0x05
#define rojo 			0x08
#define rojo_oscuro 	0x06
#define rojo_claro 		0x09
#define amarillo_oscuro	0x0A
#define amarillo_claro 	0x0B
#define magenta			0x0D
#define gris			0x0E
#define blanco			0x0F
//---- Movimientos según la entrada -----------
#define arriba			1
#define arribaDerecha	2
#define derecha 		3
#define abajoDerecha	4
#define abajo 			5
#define abajoIzquierda	6
#define izquierda 		7
#define arribaIzquierda	8
//---- Nº patrón inicial orientación sprites player ----
#define reposo			0
#define saltar 			3*4
#define saltarDer 		6*4
#define saltarIzq		9*4
#define caerIzq			12*4
#define caerDer			15*4
#define andarIzqQuieto 	18*4
#define andarIzqMov 	21*4
#define andarDerQuieto 	24*4
#define andarDerMov		27*4
#define cayendo			30*4
#define muerto			33*4
//---- Nº patrón inicial orientación sprites enemigos ----
#define pajaroIzq		36*4
#define pajaroDer		38*4
#define momiaDerecha	40*4
#define momiaIzquierda	42*4
#define esferaDerecha	44*4
#define orbeDerecha		46*4
#define ovniDerecha		48*4
#define cuernoDerecha	50*4
#define sateliteDerecha	52*4
//---- Nº patrón inicial orientación monedas ----
#define monedaCanto		54*4
#define monedaBonus		55*4
#define monedaPower		57*4
#define monedaExtra		59*4
#define monedaEspecial	61*4
#define monedaOro		63*4
//------------- Máximos ---------------
#define MAX_NIVELES		63	
#define MAX_ENEMIGOS	7	// Nº máximo de enemigos en pantalla
#define MAX_MONEDAS		2	// Nº máximo de monedas en pantalla
#define MAX_BOMBAS		24
#define MAX_ROW_WORLD   24  // nº máximo de Filas de la matriz Mundo (colisiones)
#define MAX_COL_WORLD   24  // nº máximo de Columnas de la matriz Mundo (colisiones)
//-------- Temporizadores -------------
#define Timer_Menu_MAX		500		// 10 segundos -> 10 * 50 Hz (VDP) = 500
#define Timer_Salto_MAX		96		// SCREEN_HEIGHT / 2
#define Timer_monedaNueva	600		// 12 segundos
#define Timer_monedaActiva	1000	// 20 segundos
#define Timer_momia			250		// 5 segundos
#define Timer_ovni			50		// 1 segundos
//------ Tipos básicos (Memoria) ------
#define byte			unsigned char
#define address 		unsigned int
//-------- VDP ------------------------
#define dirBaseTablaPatrones 		0x0000
#define dirBaseTablaNombres			0x1800
#define dirBaseTablaColor 			0x2000
#define dirBaseTablaSpritesPatrones 0x3800
#define dirBaseTablaSpritesAtributo 0x1B00
#define TAM_TablaPatrones 			6144
#define TAM_TablaColor				6144
#define TAM_TablaNombres			768
#define TAM_SpritesPatrones			2048
#define TAM_SpritesAtributo			128
#define SCREEN_WIDTH  				192     // Ancho de la pantalla (24 columnas x 8 pixeles)
#define SCREEN_HEIGHT 				192     // Alto de la pantalla
#define Total_Sprites				63
#define planoInicialVDPEnemigos		10
#define planoInicialVDPMonedas		20
//------------- Lógica ---------------
#define TAM_celda_Mundo			8
#define offsetPlataforma		9
#define offsetBomba				73
#define LongHOF					8
#define escenario  				0
#define arreglo	  				1
#define HORINZONTAL				0
#define VERTICAL				1
//---- FX -----
#define AFB_SIZE 				1450		// Tamaño en bytes del banco FX afb

// Identificadores
enum t_id { FONDO, PLAYER, PAJARO, MOMIA, ESFERA, ORBE, OVNI, CUERNO, SATELITE, PLATAFORMA, BOMBA, MONEDA };

// Estados para el avatar y los enemigos
enum t_states { IDLE, W_RIGHT, W_LEFT, JUMP, J_RIGHT, J_LEFT, J_HIGH, J_HIGH_LEFT, J_HIGH_RIGHT, FALLING, F_RIGHT, F_LEFT, ALIVE, DEAD, LOOK_RIGHT, LOOK_LEFT };

// Tipos de Monedas
enum t_subMoneda { B, P, E, S, O }; // B-> Bonus, P-> Power, E-> Extra, S -> Special, O -> Oro

//------ Salón de la Fama ------
typedef struct {
	unsigned int puntos;
	char nombre[4];
	unsigned char nivel;
} t_HallOfFame;

//------- BOMBA que compone la lista de bombas
typedef struct _bomba {
	unsigned char x,y;	// posicion origen (esquina superior izquierda) de la bomba en la matriz Mundo
	boolean recogida;		// indica si la bomba ha sigo recogida
	boolean encendida;		// indica si una bomba está encendida o apagada
} t_bomba;


//------ Interfaz grafico ------
typedef struct {
	unsigned int HiScore, scoreLevel;
	unsigned char multiplicador;	// valor entre [1, 5]
	float barraEnergia;				// valores entre [0, 4]
	unsigned char nivel;			// indica el nivel actual
} t_GUI;

//------ Player (Jack) ------
typedef struct {
	unsigned char spriteActual; // sprite actual de la animación
	unsigned char spriteInicio; // sprite incial en la animación
	unsigned char plano;	// plano del VDP en el que se situa
	unsigned char x1, x2, y1, y2;	// volumen inclusión AABB
	unsigned char fila, columna;	// posición que ocupa en la matriz Mundo
	unsigned char estadoActual;		// estado actual de su máquina de estados
	unsigned int PlScore;			// puntuación del jugador
	unsigned char bombas;			// nº de bombas recojidas
	unsigned char enemigos;			// nº de enemigos matados
	unsigned char cuentaSalto;		// temporizador para el salto
	char vidas;			// nº de vidas restantes
	int x, y;		// coordenadas de la pantalla donde se dibuja el sprite
	int dx, dy; 	// velocidad a la que se mueve por cada eje de la pantalla	
	boolean grounded;		// indica si toca suelo/plataforma o si está en el aire
	boolean ceiling;		// indica si choca con una plataforma por arriba
	boolean leftBounded;	// indica si limita con algo a la izquierda
	boolean rightBounded;	// indica si limita con algo a la derecha
	boolean inmunidad; 	// para testeo
} t_Player;

//------ Enemigos ------
typedef struct {
	unsigned char id; 	// id. enemigo (2->pájaro, 3->momia, 4->esfera, 5->orbe, 6->ovni, 7->cuernos, 8->satélite)
	unsigned char spriteActual; // sprite actual de la animación
	unsigned char spriteInicio; // sprite incial en la animación
	unsigned char plano;	// plano del VDP en el que se situa
	unsigned char x1, x2, y1, y2;	// volumen inclusión AABB
	unsigned char fila, columna;	// posición que ocupa en la matriz Mundo
	unsigned char estadoActual;		// estado actual de su máquina de estados	
	unsigned char orientacion;		// indica is mira a la izquierda o derecha
	unsigned int temporizador;		// mide el tiempo de la MOMIA antes de caer de las plataformas
	int x, y;		// coordenadas de la pantalla donde se dibuja el sprite
	int dx, dy; 	// velocidad a la que se mueve por cada eje de la pantalla	
	boolean eje;		// eje sobre el que se mueve el enemigo PAJARO (true -> VERTICAL, false -> HORIZONTAL)
	boolean grounded;	// indica si toca suelo/plataforma o si está en el aire
	boolean ceiling;	// indica si choca con una plataforma por arriba
	boolean leftBounded;	// indica si limita con algo a la izquierda
	boolean rightBounded;	// indica si limita con algo a la derecha
} t_Enemigo;

//---- Monedas ----
typedef struct {
	unsigned char id; 	// id. enemigo (2->pájaro, 3->momia, 4->esfera, 5->orbe, 6->ovni, 7->cuernos, 8->satélite)
	unsigned char tipo; // subtipo de moneda (B,P,E,S,O)
	unsigned char spriteInicio; 	// sprite incial en la animación
	unsigned char spriteActual; 	// sprite actual de la animación
	unsigned char fila, columna;	// posición que ocupa en la matriz Mundo
	unsigned char color;
	unsigned char plano;	// plano del VDP en el que se situa
	int x, y;		// coordenadas de la pantalla donde se dibuja el sprite
	int dx, dy; 	// velocidad a la que se mueve por cada eje de la pantalla	
	int time;		// tiempo de vida de la moneda
	boolean activa;	// indica si la moneda está activa (es visible)
	boolean grounded;	// indica si toca suelo/plataforma o si está en el aire
	boolean ceiling;		// indica si choca con una plataforma por arriba
	boolean leftBounded;	// indica si limita con algo a la izquierda
	boolean rightBounded;	// indica si limita con algo a la derecha
} t_Moneda;

//---- Entrada desde Teclado o Joystick ----
typedef struct  {
	char movimiento;
	char salto;
} t_Entrada;


//------ Niveles ------
// fila 0 - Escenarios (1-Egipto, 2-Grecia, 3-Alemania, 4-NY, 5- LA)
// fila 1 - Arreglos (A..P)
//
// Obtener el escenario del nivel actual -> niveles[escenario][nivel_actual]
// Obtener el arreglo del nivel actual -> niveles[arreglo][nivel_actual]

const unsigned char niveles[2][MAX_NIVELES/*+1*/]={
{1,2,3,4,5,1,2,3,4,5,1,2,3,4,5,1,2,3,4,5,1,2,3,4,5,3,3,2,1,5,1,3,4,1,2,4,2,3,1,1,3,3,2,4,2,3,3,4,2,4,1,1,2,4,2,1,2,1,3,3,3,2,4},
{'A','B','C','D','E','F','G','H','I','A','J','K','L','M','E','N','O','P','B','N','K','G','D','L','M','P','H','O','J','A','F','C','M','N','G','I','L','O','F','F','H','P','G','D','K','C','L','I','B','I','J','N','K','M','G','A','O','F','H','C','P','G','D'}
};

//----------- VARIABLES GLOBALES -----------------
byte tablaPatrones[TAM_TablaPatrones];
byte tablaColor[TAM_TablaColor];
byte tablaNombres[TAM_TablaNombres];
byte buffer_tablaNombres[TAM_TablaNombres];
byte nBombas, nextBomba;						// número de bombas por recoger y proxima bomba a encenderse
byte nPajaros;									// número de enemigos tipo pájaro en pantalla
byte nMonedas;									// número de monedas en pantalla
byte nEnemigos;									// número de enemigos en pantalla
byte nMonedasORO;								// número de enemigos convertidos en Moneda ORO
t_GUI gui;										// interfaz gráfico
t_Player player;								// jugador
t_Enemigo listaEnemigos[MAX_ENEMIGOS];			// lista de enemigos (máx. enemigos en pantalla = 7)
boolean reordenarListaEnemigos;					// bandera que indica si hay que reordenar la lista de enemigos
t_Moneda listaMonedas[MAX_MONEDAS];				// lista de monedas (máx. monedas en pantalla = 2)
t_bomba lista_bombas[MAX_BOMBAS];				// lista de bombas ordenadas por encendido
byte Mundo[MAX_COL_WORLD][MAX_ROW_WORLD];		// Matriz que modela el mundo (nivel)
byte velocidad = 0x11;							// nibble alto -> velocidada avatar, nibble bajo -> velocidad enemigo y monedas
boolean pintafondo = false;						// indica cuando hay que actualizar el fondo
